/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import { env, ResizeNearestNeighbor } from '@tensorflow/tfjs-core';
import { ResizeNearestNeighborProgram } from '../resize_nearest_neighbor_gpu';
import { ResizeNearestNeighborPackedProgram } from '../resize_nearest_neighbor_packed_gpu';
export function resizeNearestNeighbor(args) {
    const { inputs, backend, attrs } = args;
    const { images } = inputs;
    const { alignCorners, halfPixelCenters, size } = attrs;
    const [newHeight, newWidth] = size;
    const program = env().getBool('WEBGL_PACK_IMAGE_OPERATIONS') ?
        new ResizeNearestNeighborPackedProgram(images.shape, newHeight, newWidth, alignCorners, halfPixelCenters) :
        new ResizeNearestNeighborProgram(images.shape, newHeight, newWidth, alignCorners, halfPixelCenters);
    return backend.runWebGLProgram(program, [images], images.dtype);
}
export const resizeNearestNeighborConfig = {
    kernelName: ResizeNearestNeighbor,
    backendName: 'webgl',
    kernelFunc: resizeNearestNeighbor
};
//# sourceMappingURL=data:application/json;base64,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